﻿class Program
{
    static List<string> tasks = new List<string>();

    static void Main()
    {
        Console.WriteLine("Welcome to Alice's To-Do App!");
        while (true)
        {
            Console.WriteLine("Options:\n1. Add Task\n2. View Tasks\n3. Exit");
            Console.Write("Choose an option: ");
            string? choice = Console.ReadLine();
            if (choice == null)
            {
                continue;
            }

            if (choice == "1") AddTask();
            else if (choice == "2") ViewTasks();
            else if (choice == "3") break;
            else Console.WriteLine("Invalid option.");
        }
    }

    static void AddTask()
    {
        Console.Write("Enter a new task: ");
        string? task = Console.ReadLine();
        if (task == null)
        {
            return;
        }
        tasks.Add(task);
        Console.WriteLine("Task added!");
    }

    static void ViewTasks()
    {
        Console.WriteLine("\nYour tasks:");
        if (tasks.Count == 0) Console.WriteLine("(No tasks yet)");
        else
        {
            for (int i = 0; i < tasks.Count; i++)
                Console.WriteLine($"{i + 1}. {tasks[i]}");
        }
    }
}
