﻿#version 330 core
layout(location = 0) in vec3 aPosition;
layout(location = 1) in vec3 aNormal;

uniform mat4 uModel;
uniform mat4 uView;
uniform mat4 uProjection;

out vec3 FragPos;
out vec3 Normal;
out vec3 ViewPos;

void main()
{
    FragPos = vec3(uModel * vec4(aPosition, 1.0));
    Normal = mat3(transpose(inverse(uModel))) * aNormal;
    
    ViewPos = vec3(inverse(uView) * vec4(0.0, 0.0, 0.0, 1.0));
    
    gl_Position = uProjection * uView * vec4(FragPos, 1.0);
}